///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _SETGUIPWD_CPP
#define _SETGUIPWD_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/HashKey.H"
#include "../../SharedSource/Common.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "SetNewGUIPwd.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK SetGUIPwdDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND hPassword1 = NULL;
    static HWND hPassword2 = NULL;

    //--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG)
    {
        char sCaption[1024];
		sprintf_s(sCaption, sizeof(sCaption), "%s :: %s", gsTitleCaption, "Set Password");
        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        hPassword1 = GetDlgItem(hWnd, IDC_PASSWORD1);
        hPassword2 = GetDlgItem(hWnd, IDC_PASSWORD2);

        Set_Text(hPassword1, "");
        Set_Text(hPassword2, "");

        CenterWindow(hWnd);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
		if(wParam == IDC_CMDOK)
		{
			char sPwd1[1024];
			char sPwd2[1024];

			int iSz1 = Get_TextEx(hPassword1, sPwd1, sizeof(sPwd1));
			int iSz2 = Get_TextEx(hPassword2, sPwd2, sizeof(sPwd2));

			if(iSz1 > 0 && iSz1 < sizeof(sPwd1))
			{
				if(strcmp(sPwd1, sPwd2) == 0)
				{
					char sHash[256];
					int iMaxHash = sizeof(sHash) - 1;

					HashKey((const unsigned char *)sPwd1, (unsigned char *)sHash, iSz1, iMaxHash);

					sHash[iMaxHash] = '\0';

					Set_BinaryRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "GUIPWD", sHash, iMaxHash);

					EndDialog(hWnd, 0);
				}
				else{
					MessageBox(hWnd, "The passwords you entered do not match.", gsTitleCaption, MB_ICONINFORMATION);
					return TRUE;
				}
			}

			return TRUE;
		}

		if(wParam == IDC_CMDCANCEL)
		{
			EndDialog(hWnd, 0);
			return TRUE;
		}

		return FALSE;
    }

    //--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE)  // Received Close Message
    {
        EndDialog(hWnd, 0);
        DestroyWindow(hWnd);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

